function [obj] = vb_m_stack_push(obj, push_data)
% push data into memory stack
% [USAGE]
%    [obj] = vb_m_stack_push(<obj>, <push_data>);
% [IN]
%          obj : m_stack object.
%    push_data : push data into m_stack.
% [OUT]
%    obj : m_stack object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('push_data', 'var')
    error('push_data is a required parameter.');
end

%
% --- Main Procedure
%
if ~isinf(obj.stack_size) && (length(obj.queue) >= obj.stack_size)
    % delete top
    obj.queue(1) = [];
end

% push back
obj.queue = [obj.queue; push_data];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end

