function [obj, data] = vb_f_stack_pop(obj)
% pop data from file stack
% [USAGE]
%    [obj, data] = vb_f_stack_pop(<obj>);
% [IN]
%    obj : f_stack object.
% [OUT]
%     obj : f_stack object.
%    data : pop data from f_stack.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
data = [];
last_ix = length(obj.queue);
if last_ix ~= 0
    temp_file = obj.queue{last_ix};
    load(temp_file, 'data');
    % delete pop data
    if ~isempty(obj.queue{last_ix}) && exist(obj.queue{last_ix}, 'file') == 2
        delete(obj.queue{last_ix}); % delete file
        obj.queue(last_ix) = [];
    end
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
