function varargout = dir_dialog(varargin)
% This function creates a directory choice dialog.
% Usage:
%  dir = dir_dialog(start_dir, move_mode);
%        or
%  dir = dir_dialog; % start_dir is 'C:'     (Windows)
%                    %              '/home'  (Unix, Linux)
%
% [IN] start_dir : directory select starting point.
% [IN] move_mode : true or false (able to omit)
%                  true  : We can move to all directory.(default)
%                  false : We only to move to lower directory than start_dir.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin == 0  % no input argument

    if ispc % Windows
        [varargout{1}] = init('C:', true);
    else    % Unix/Linux
        [varargout{1}] = init('~', true);
    end

else
    try
        if nargout == 0
            init(varargin{:})
        else
            [varargout{1}] = init(varargin{:}); % FEVAL switchyard
        end
    catch
        disp(lasterr);
    end
end

% --------------------------------------------------------------------
function dir = init(start_dir, move_mode)
    % directory movable area
    if ~exist('move_mode', 'var')
        move_mode = true; % We can move to all directory
    end
    
    % directory check
    if (dir_dialog_callback('IsdirOK', start_dir) == false) | isempty(start_dir) 
        start_dir = pwd;
    end
    
    fig = openfig(mfilename,'reuse');

    % Generate a structure of handles to pass to callbacks, and store it. 
    handles = guihandles(fig);

    % Initialize
    handles.START_DIR   = start_dir;
    handles.mypath      = start_dir;
    handles.move_mode   = move_mode;

    % disk drive detection
    if ispc & handles.move_mode == true
        dir_dialog_callback('set_drive_info', handles, start_dir);
    else
        % UNIX, LINUX doesn't have a disk drive.
        set(handles.drive_label, 'Visible', 'off');
        set(handles.drive_popup, 'Visible', 'off');
    end

    % display start_dir
    handles = dir_dialog_callback('update_listbox', handles);

    % save data
    guidata(fig, handles);

    % User operation is done in the wait loop.
    waitfor(handles.browser, 'Visible', 'off');
    
    % When user operation is finished, loop is dropping out.
    handles = guidata(handles.browser);
    dir = handles.mypath;
    delete(handles.browser);

