function [parm, spm_list] = vb_load_fmri_proj(parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2005-03-20 Modified by TY
%global	define
global vbmeg_inst; 
define = vbmeg_inst.const; 

if ~isempty( findstr(parm.file.act, define.FMRI_EXTENSION) )
  FMRIfile =...
      parm.file.act(1:findstr(parm.file.act, define.FMRI_EXTENSION)-1);
else
  FMRIfile = parm.file.act;
end
project_fname = [parm.dir.act  FMRIfile define.FMRI_PROJECT_EXTENSION];
fd = fopen(project_fname, 'r');

CR = sprintf('\n');	% ԥ
spm_list = {};


while true
  str = fgets(fd);
    
  if str == -1
    break;		% End of FILE
  elseif strcmp(str, CR) | str(1)=='#'
    ;			% '#'ǻϤޤԤCOMMENT line
  else
    % ǡե̾ȥǥ쥯ȥ̾ɤࡣ
    brain_dir = sscanf(str, 'dir.brain = %s');
    brain_file = sscanf(str, 'file.brain = %s');
    area_dir = sscanf(str, 'dir.area = %s');
    area_file = sscanf(str, 'file.area = %s');
    fmri_dir = sscanf(str, 'dir.act = %s');
    fmri_file = sscanf(str, 'file.act = %s');

    % commentԤɤࡣ
    fmri_comment = strncmp(str, 'brain_parm.act_comment =', ...
	length('brain_parm.act_comment ='));

    spm_id = sscanf(str, 'SPM_ID%d');


    if ~isempty(brain_dir)		parm.dir.brain = brain_dir;
    elseif ~isempty(brain_file)		parm.file.brain = brain_file;   
    elseif ~isempty(area_dir)		parm.dir.area = area_dir;
    elseif ~isempty(area_file)		parm.file.area = area_file;
    elseif ~isempty(fmri_dir)		parm.dir.act = fmri_dir;
    elseif ~isempty(fmri_file)		parm.file.act = fmri_file;
      
    elseif fmri_comment
      parm.brain_parm.act_comment = ...
	  sscanf(str, 'brain_parm.act_comment = %s');
      
    elseif  ~isempty(spm_id)
      tmp = sprintf('SPM_ID%d = %%s', spm_id);
      spm_list{spm_id} = sscanf(str, tmp);
    end
    
  end	% <-- End of 'if str == -1 ... elseif strcmp(...) ... else'
end	% <-- End of 'while true'

fclose(fd);
