function [Measurement, Device] = vb_load_device(measurement_file)
% load measurement file and get 'Measurement' and 'Device' information
%
% [usage]
%   [Measurement, Device] = vb_load_device(measurement_file)
%
% [input]
%   measurement_file : measurement file (e.g. meg_file)
%
% [output]
%   Measurement : measurement
%        Device : device
%
% [note]
%
% [history]
%   2006-09-01 (Sako) initial version
%   2007-02-21 (Sako) supported NIRS
%   2011-06-01 (Sako) modified to return values without converting to upper case
%   2012-07-13 (Sako) fixed an error in the case that MEG-MAT file does not
%                     have 'Measurement' field properly.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('measurement_file', 'var'), measurement_file = ''; end
if isempty(measurement_file)
  error('(%s) measurement_file is a required parameter', mfilename);
end

% initialize
Measurement = '';

[state, const] = ...
  vb_util_check_variable_in_matfile(measurement_file, 'Measurement');
if state == const.VALID
  load(measurement_file, 'Measurement');
end

% load(measurement_file, 'M*');
%
% --- You can expect that 'Measurement' and 'MEGinfo' are loaded here.
%

% if ~exist('Measurement', 'var')
if isempty(Measurement)
  % only old MEG-MAT files do not have 'Measurement' field.
  Measurement = 'MEG';
  load(measurement_file, 'MEGinfo');
  Device = inner_get_device_meg(MEGinfo);
  return;

else
  measurement = upper(Measurement);

  switch measurement
    case  'MEG'
      meginfo = vb_megfile_load_meginfo(measurement_file);
      Device = inner_get_device_meg(meginfo);
      return;
            
    case  'EEG'
      eeginfo = vb_eegfile_load_eeginfo(measurement_file);
      Device = vb_eeginfo_get_device(eeginfo);
      return;

    case  'NIRS'
      load(measurement_file, 'device');
      Device = device;
      return;
      
    case  'INFO'
      %load(measurement_file,'fileinfo');
      Device = 'INFO';
      
    otherwise
      error('ERROR: unknown measurement is set : %s\n', measurement);
  end
end
return;

% --- inner_get_device_meg()
%
function [device] = inner_get_device_meg(meginfo)
device = vb_meginfo_get_device(meginfo);
if isempty(device)
  % old fashioned
  device = 'SBI';
end
return;
%
% --- end of inner_get_device_meg()

% --- END OF FILE --- %
