function vb_rm_area(areafile,area_key,flag)
% This function is used to remove cortical area data. 
%
% --- Syntax
% vb_rm_area(areafile,area_key,flag)
%
% --- Input
% areafile: Cortical area file (.area.mat)
% area_key: ID of area information to be removed
%
% --- Optional input
% - flag  : If OFF, confirmation dialog will be suppressed. 
%
% --- Output
%
% --- Example
% >> areafile = './TY/data/TY.area.mat';
% >> area_key = 'tmp';
% >> vb_rm_area(areafile,area_key);
%
% --- History
% 2004-12-27 Taku Yoshioka
% 2006-08-11 Taku Yoshioka (dialog suppression flag)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3, flag=ON; end
Area = [];
if exist(areafile) == 2
  load(areafile);
  % Support for old version
  if ~exist('MRI_ID'), 
    MRI_ID = '0000000';
    disp(['--- Area file ''' areafile ''' is a old version, ' ...
	  'in which variable ''MRI_ID'' is not saved. A tentative ' ...
	  'ID ''0000000'' was automatically assigned to the area ' ...
	  'file.']);
  end
else
  disp('Area data file is not found.');
  return;
end

for i = 1:length(Area)
  if strcmp(area_key,Area{i}.key)
    AreaNew = cell(length(Area)-1,1);
    for j = 1:i-1
      AreaNew{j} = Area{j};
    end
    for j = i+1:length(Area)
      AreaNew{j-1} = Area{j};
    end
    Area = AreaNew;
    vb_fsave(areafile,'Area','MRI_ID');
    if flag,
      h = msgbox(['Area ''' area_key ''' was removed.']);
      uiwait(h);
    end
    return;
  end
end

error(['Area ''' area_key ''' is not found.']);

