function vb_rm_act(actfile,act_key,flag)
% This function is used to remove cortical activity data. 
%
% --- Syntax
% vb_rm_act(actfile,act_key,flag)
%
% --- Input
% actfile: Cortical activity file (.act.mat)
% act_key: ID of area information to be removed
%
% --- Optional input
% - flag  : If OFF, confirmation dialog will be suppressed. 
%
% --- Output
%
% --- Example
% >> actfile = './TY/data/TY.act.mat';
% >> act_key = 'tmp';
% >> vb_rm_act(actfile,act_key);
%
% --- History
% 2004-12-27 Taku Yoshioka
% 2006-08-11 Taku Yoshioka (dialog suppression flag)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<3, flag=ON; end

if exist(actfile) == 2
  load(actfile);
  % Support for old version
  if ~exist('MRI_ID'), 
    MRI_ID = '0000000';
    disp(['--- Activity map file ' actfile ' is a old version, ' ...
	  'in which variable ''MRI_ID'' is not saved. A tentative ' ...
	  'ID ''0000000'' was automatically assigned to the activity' ...
	  ' map file.']);
  end
else
  disp('Activity map file is not found.');
  return;
end

for i = 1:length(Act)
  if strcmp(act_key,Act{i}.key)
    ActNew = cell(length(Act)-1,1);
    for j = 1:i-1
      ActNew{j} = Act{j};
    end
    for j = i+1:length(Act)
      ActNew{j-1} = Act{j};
    end
    Act = ActNew;
    vb_fsave(actfile,'Act','MRI_ID');
    if flag, 
      h = msgbox(['Activity map ''' act_key ''' was removed.']);
      uiwait(h);
    end
    return;
  end
end

error(['Activity map ''' act_key ''' is not found.']);
