function keyset = vb_get_keyset_act(actfile)
% This function is used to get the set of cortial activity map IDs. 
%
% --- Syntax
% keyset = vb_get_keyset_act(actfile)
%
% --- Input
% actfile: Cortical activity file (.act.mat). 
%
% --- Optional input
%
% --- Output
% keyset{i}: Set of IDs of cortical activity maps. 
%
% --- Example
% >> actfile = './TY/data/TY.act.mat';
% >> key = vb_get_keyset_act(actfile);
%
% --- History
% 2004-10-09 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if exist(actfile) ~= 2
  error(['Activity map file is not found.']);
  keyset = [];
else
  load(actfile,'Act')
  keyset = cell(length(Act),1);
  for i = 1:length(Act)
    keyset{i} = Act{i}.key; 
  end
end
