function	[V,F] = vb_trans_index(V,FF,indx)
% Select vertex and patch from surface
%    [V,F] = vb_trans_index(V,FF,indx)
% --- Input
% V  : vertex of surface
% FF : patch index
% indx : index of selected vertex
% --- Output
% V : selected vertex
% F : patch index which include selected vertex
%
% Ver 1.0  by M. Sato  2004-2-10
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
%------ 3ѷֹ򿷤ĺб褦Ѵ -------
%
Npoint = size(V,1);  	% ĺ
Nnew = length(indx);
V	 = V(indx,:);

% ĺֹ椫鿷ĺֹѴѴɽ
% Itrans(i)=0 : ĺֹ = i Ͽĺ˴ޤޤʤ
% Itrans(i)=j : ĺֹ = i Ͽĺ = j б
Itrans		 = zeros(Npoint,1);
Itrans(indx) = 1:Nnew;

% 3ѷֹ򿷤ĺб褦Ѵ
% 3ѷƤĺĺ˴ޤޤ3ѷõ
FF	= Itrans(FF);
ixF = find(prod(FF ,2) ~= 0 );
F   = FF(ixF,:);

return
