function  [Fnew, Vnew, xxn, indx, ix_miss] = vb_out_normal_surf(F,V,normal_mode)
% extract connected surface & make normal vector outward
%  [Fnew, Vnew, xxn, indx, ix_miss] = vb_out_normal_surf(F,V)
% --- Input
% V : vertex of surface
% F : patch index
% normal_mode
% --- Output
% normal_mode = 0
%   Vnew : vertex coordinate for connected surface
%   Fnew : patch index for connected surface
%   xxn  : normal vector for connected surface points 'Vnew'
%   indx : original vertex index of connected vertex points
%   ix_miss : original vertex index of disconnected vertex points
% normal_mode = 1 (Default)
%   Vnew = V
%   Fnew : patch index for connected surface
%   xxn  : normal vector for 'V'
%          xxn(n,:) = 0, if V(n,:) is disconnected point
%   indx : vertex index of connected vertex points
%   ix_miss : vertex index of disconnected vertex points
%
% M. Sato  2006-7-20
%
% ݥꥴǥλˡθ򳰸·
%
%  르ꥺ 
% ĺꥹȤ˴ؤ롼
% ĺꥹȤ롼ĺ
%롼̤ܻ̤õ
%ܻ̤ǽĺޤΤõ
%ĺ¤·
%̤Τ⤦Ĥĺ򺣲κǽĺˤ
%ĺꥹȤ˸ꤷդĺɲä
%̤̤ĤäƤУ
%̤μĺĤäƤУ
%ꤷĺꥹȤ򿷤ꥹȤˤƣ
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('normal_mode','var'), normal_mode = 1; end;

seedID=1;

Npoint = size(V,1);  	% ĺ
Npatch = size(F,1);  	% ̿

xxn   = zeros(Npoint,3);	% ˡ

Plist = zeros(Npoint,2);	%  ĺꥹ
Vlist = zeros(Npoint,2);	%  ĺꥹ
Vflg  = zeros(Npoint,1);	% ĺѤߥե饰
Fflg  = zeros(Npatch,1);	% ̽Ѥߥե饰
FF	  = zeros(Npatch,3);	% ̥ǥå

% ǥåꥹȤκ
xxF  = vb_neighbor_index(V,F);

% 롼ȥǥå
Plist(1,:) = [seedID, xxF{seedID}(1,1)];

Nlist =1;%  ĺ
Nroot =0;% Ѥĺ

while Nlist > 0,

	Nedge = 0;%  ĺ
	
	% ĺ˴ؤ롼
	for n=1:Nlist,
	    % root ǥå next ǥåι
	    root = Plist(n,1);
	    next = Plist(n,2);
		
		% root ǥåꥹ
		nextID = xxF{root}; 	
	    
	    % ꥹ
	    nlist1 = nextID(:,1); 	% ꥹ1
	    nlist2 = nextID(:,2); 	% ꥹ2
	    flist  = nextID(:,3); 	% ܻ̥ꥹ
	    
	    % ̤̥ǥåõ
	    nextix = find( Fflg(flist) == 0 );
	    
	    if isempty(nextix), 
	    	continue;
	    end;
	    
	    % ̤̤Υǥåꥹ
	    nlist1 = nlist1(nextix);
	    nlist2 = nlist2(nextix);
	    flist  = flist(nextix);
	    
	    Nnext  = length(nextix);
	    Nnew   = Nnext;
	
	    % root ܤ̤̥롼
	    for i=1:Nnext, 
	    	% nlist1/2 ǡĺ next ޤ̤õ
	        jx1  = find( nlist1==next );
	        jx2  = find( nlist2==next );
	        
	        if ~isempty(jx1),
		       	nold  = next;
	        	jj	  = jx1(1);	    % next ޤ̤Υꥹֹ
	        	fid   = flist(jj);  % next ޤֹ̤
	        	next  = nlist2(jj); % ̤Τ⤦Ĥλĺ

	        	%  ĺꥹȤɲ
	        	Nedge = Nedge + 1;
	        	Vlist(Nedge,:) = [next nold];
		        % ĺǥåؤ
		        FF(fid,:) = [root, nold, next];
		        % ̤ѤߥꥹȤ
		        Fflg(fid) = 1;
				% ĺѤߤˤ
				Vflg([root, nold, next]) = 1;
		        
		        % ̤̥ꥹȤ
		        inew   = [1:(jj-1),(jj+1):Nnew];
		        flist  = flist(inew);
		        nlist1 = nlist1(inew);
		        nlist2 = nlist2(inew);
		        Nnew   = Nnew-1;
	        elseif ~isempty(jx2),
		       	nold  = next;
	        	jj	  = jx2(1);	    % next ޤ̤Υꥹֹ
	        	fid   = flist(jj);  % next ޤֹ̤
	        	next  = nlist1(jj); % ̤Τ⤦Ĥλĺ

	        	%  ĺꥹȤɲ
	        	Nedge = Nedge + 1;
	        	Vlist(Nedge,:) = [next nold];
		        % ĺǥåؤ
		        FF(fid,:) = [root, nold, next];
		        % ̤ѤߥꥹȤ
		        Fflg(fid) = 1;
				% ĺѤߤˤ
				Vflg([root, nold, next]) = 1;
		        
		        % ̤̥ꥹȤ
		        inew   = [1:(jj-1),(jj+1):Nnew];
		        flist  = flist(inew);
		        nlist1 = nlist1(inew);
		        nlist2 = nlist2(inew);
		        Nnew   = Nnew-1;
	        end;
	    end
	    % END- (root) ܤ̤̥롼 
	    
	end;
	% END-ĺ˴ؤ롼
	
	%  ĺꥹȤι
	Nlist = Nedge;
	Plist(1:Nedge,:) = Vlist(1:Nedge,:);

end

% ѤߤĺȻ̤Ф
indx = find(Vflg == 1);
inxf = find(Fflg == 1);
Fnew = FF(inxf,:);

% ̤ĺȻ̤Ф
ix_miss = find(Vflg == 0);

switch	normal_mode
case	0
	%  Vnew : connected surface vertex
	%  xxn  : normal vector for 'Vnew'
	[Vnew, Fnew] = vb_trans_index( V, Fnew, indx);
	% outward normal vector
	[xxn , Fnew] = vb_out_normal_vect(Vnew,Fnew);
case	1
	%  Vnew = V
	%  xxn(n,:) = 0, if V(n,:) is disconnected point
	Vnew = V;
	% outward normal vector
	[xxn , Fnew] = vb_out_normal_vect(Vnew,Fnew);
	xxn(ix_miss,:) = 0;
end

%fprintf('New version\n')
