function [CW ,ixall] = vb_step_filter(nextDD,nextIX,R,Index)
% Calculate step function filter on cortical surface 
% --- Syntax
% function [CW ,ixall] = spatial_average_filter(nextDD,nextIX,R,Index)
%
% --- Input
% nextDD      : Distance to neighbour vertices
% nextIX      : Indices of neighbour vertices
% R           : Smoothing filter radius
% Index       : Vertex index for selected area
%
% --- Optional Input
% flag = 0    : output region = input region
%      = 1    : extend output region to neighbor of edge (Default)
%
% --- Output
% CW          : Smoothing Gaussian filter
% ixall       : Vertex index for smoothing filter
%               smoothed_leadfield(:,Index) = leadfield(:,ixall) * CW
%
% --- History
% 2007-02-23 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nvertex = length(Index);	% # of points in selected area
Nall	= length(nextIX);	% # of points in whole brain
rIndex = Index;   

% Calculate total number of neighbors (Nnext)
Nnext   = 0;

for n=1:Nvertex,
  inx   = find( nextDD{rIndex(n)} <= R );	% neighbor within Rmax
  Nnext = Nnext + length(inx);
end;

% Initialize variable
val 	= zeros(Nnext,1);	% Filter value
ipoint	= zeros(Nnext,1);	% Center point index
inext	= zeros(Nnext,1);	% Neighbor index
Nbegin  = 1;

% Find neighbor within Rmax and calculate Gaussian filter value
for n=1:Nvertex,
	i	= rIndex(n);		% center vertex index
	dd0 = nextDD{i};		% Neighbor distance
	inx = find( dd0 <= R );	        % Find neighbor within Rmax
	
	ix = nextIX{i}(inx);		% Neighbor index within Rmax
	dd0 = dd0(inx);			% Neighbor distance
	
	% Filter value
	vdd = ones(length(inx),1);      % Spatial filter
	vdd = vdd/sum(vdd);		% Normalization
	
	% Total # of neighbor points
	Nend   = Nbegin + length(inx) - 1;
	Indx   = Nbegin:Nend;
	Nbegin = Nend + 1;
	
	ipoint(Indx) = n;		% center vertex index
	inext(Indx)  = ix ;     % Neighbor index
	val(Indx)    = vdd;		% Gaussian filter value

end;

ipoint = ipoint(1:Nend);
inext  = inext(1:Nend) ;
val    = val(1:Nend)   ;
    
CW    = sparse( inext , ipoint , val , Nall, Nvertex) ;
ixall = unique(inext);
CW    = CW(ixall,:);        
