function [nextIXnew, nextDDnew]=vb_reduce_neighbor_data(Vindx,nextIX,nextDD)
%  Generate the neighbor information of subregion (Vindx) from that of whole brain 
%   [nextIXnew, nextDDnew]=vb_reduce_neighbor_data(Vindx,nextIX,nextDD)
% ---- Input
% Vindx     : Vertex indices of subregion as whole brain indices
% nextIX{i} : Neighbor index list for the point i
% nextDD{i} : Distance from the point i
%
% ---- Table [[ old indices  (whole brain) -> new indices (subregion) ]] 
% Itrans(i)=0 : old index = i is not included in the new index set
% Itrans(i)=j : old index = i is correspond to new index = j 
% jx = Itrans(ix) : Transform old index ix to new index jx
%
% Ver 1.0 written by M. Sato  2003-3-15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Nvertex  = length(Vindx);
Nall	 = size(nextDD,1);

nextIXnew  = cell(Nvertex,1);
nextDDnew  = cell(Nvertex,1);

Itrans		  = zeros(Nall,1);
Itrans(Vindx) = 1:Nvertex;

for i=1:Nvertex,
	ix	   = Vindx(i);
	
	inext  = nextIX{ix};
    nextdd = nextDD{ix};
    
    jnext  = Itrans(inext);
    indx   = find( jnext ~= 0 );
    
    nextIXnew{i} = jnext(indx);
    nextDDnew{i} = nextdd(indx);
end;
