function  [Vnew,Fnew,xxnew,Vinfo] = vb_get_cortex_info(V, F, xx, X0)
% Make smooth cortex from brain model by morphological smoothing
%  [Vnew,Fnew,xxnew,Vinfo] = vb_get_cortex_info(V, F, xx, X0)
%--- Input 
%
% V  : Cortical vertex point cordinate , Analyze_right [mm]
% F  : Patch index structure
% xx : normal
% X0 : left/right center
%--- Output 
%
% Vnew  : Cortical vertex point cordinate     [Nvertex, 3]
% xxnew : Normal vector to cortical surface   [Nvertex, 3]
% Fnew  : Patch index structure
%  .F3R	: Right cortex
%  .F3L	: Left  cortex
%  .F3	: Left + Right
% Vinfo        : Vertex dimension structure
%   .Ndipole   : # of vertex
%   .NdipoleL  : # of vertex in Left cortex
%   .Npatch    : # of patch
%   .Coord     = 'Analyze_Right_mm';
%
% Made by M. Sato 2007/6/15
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Ndipole = size(V,1);

% Find Left/Right cortex

ixL = find(V(:,1) <= X0(1));
ixR = find(V(:,1) >  X0(1));

% Left/Right ordering
Vix = [ixL ; ixR ];
Vnew  = V(Vix,:);
xxnew = xx(Vix,:);

Itrans = zeros(Ndipole,1);
Itrans(Vix) = 1:Ndipole;

F  = Itrans(F);
NL = length(ixL);

Fnew.F3L = vb_patch_select([1:NL],F,Ndipole);
Fnew.F3R = vb_patch_select([(NL+1):Ndipole],F,Ndipole);
Fnew.F3  = F;
Fnew.NdipoleL = NL ;

% Dimensional info
Vinfo.NdipoleL  = NL ;
Vinfo.Ndipole   = Ndipole;
Vinfo.Npatch    = size(F,1);
Vinfo.Coord     = 'Analyze_Right_mm';
