function    [d1, overlap, ddmin, Indx, iter] = ...
    vb_find_no_overlap(d,overlap,Rmax)
% try to find no overlap mapping
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% d = Dinv = vb_sparse_inv_distance(Vref,Vnew, Rmax);
% inverse distances between Vref and Vnew

d1=d;
dinv_max=1/Rmax;

maxiter = 1000;

for iter = 1: maxiter
    for n = 1:overlap.Noverlap
    	% overlaped Vref index
		ix_ref = overlap.Ovlist(n);
	   	% Multiplicity of overlaped index
		Nmulti = overlap.Nmulti(n);
		% index list of new vertex for ix_ref
		ix_new = overlap.Inew{n};
		
		for m=1:Nmulti
            [tmp, b]  = max(d1(ix_ref,ix_new));
            ix_new(b) = [];
            d1(ix_ref,ix_new) = dinv_max;
        end
    end
    
    % find overlap index
	[overlap, ddmin, Indx] = vb_find_overlap(d1);
    
	if overlap.Noverlap == 0, break; end
end

%fprintf('iter = %d, Noverlap = %d\n',iter, overlap.Noverlap), 

return;

if overlap.Noverlap == 0, 
	%dd_max2 = overlap.dmin;
	fprintf('dmax(pre) = %g, dmax(poat) = %g, iter = %d\n',...
		dd_max1,dd_max2,iter)
else
	fprintf('iter = %d, Noverlap = %d\n',iter, overlap.Noverlap), 
end

return;
