function	Findx = vb_find_big_triangle(F,V,Dmax)
% Find triangle with large length
%  Findx = vb_find_big_triangle(F,V,Dmax)
%
% Dmax : Max distance
%
% written by M. Sato  2005-4-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Npatch = size(F,1);  		% number of patch
dd=zeros(3,1);

Findx = [];

% ̤˴ؤ롼
for j=1:Npatch,
    % ̤ĺǥå
    k  = F(j,:); 
    % ̤ĺ
    X = V(k,:);
    % 3դĹ
    dd(1) = (X(1,1)-X(2,1)).^2 + (X(1,2)-X(2,2)).^2 + (X(1,3)-X(2,3)).^2;
    dd(2) = (X(2,1)-X(3,1)).^2 + (X(2,2)-X(3,2)).^2 + (X(2,3)-X(3,3)).^2;
    dd(3) = (X(3,1)-X(1,1)).^2 + (X(3,2)-X(1,2)).^2 + (X(3,3)-X(1,3)).^2;
	
	if max(sqrt(dd)) > Dmax,
		Findx = [Findx; j];
	end
end;
