function	vb_copy_std_atlas_area(brainfile, Nvertex)
% Copy atlas area/act files of standard brain to the same directory of brainfile
%
%  vb_copy_std_atlas_area(brainfile, Nvertex)
%
% [history]
% 2015-12-27 M. Sato 
%   Ver.2.0 New version for group analysis
% 2019-12-02 rhayashi
%   copy all the area/act files inside standard brain directory.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- Set standard brain
[std_parm, proj_root] = vb_set_icbm152(Nvertex);
std_dir        = fullfile(std_parm.std_dir, [std_parm.std_id, '_', num2str(std_parm.Nvertex)]);
std_brain_file = fullfile(std_dir, std_parm.brain_file);
std_basename   = strrep(std_brain_file, '.brain.mat', '');

% search area files inside standard brain directory
tmp_area_files = dir(fullfile(std_dir, 'mni_*.area.mat'));

% extract std files and its atlas_ids ({'_aal', 'Yeo2011_17Networks', ...}) 
std_area_files  = cell(0);
atlas_ids        = cell(0);
for k=1:length(tmp_area_files)
     std_area_files{k} = fullfile(std_dir, tmp_area_files(k).name);
     tmp = strrep(std_area_files{k}, '.area.mat', '');
     tmp = strrep(tmp, std_basename, '');
     atlas_ids{k} = tmp;
end

% Copy the standard atlas file with the subject name.
EXT_brain = '.brain.mat';
brain_id  = brainfile(1:findstr(brainfile,EXT_brain)-1);

for k=1:length(std_area_files)
    std_area_file = std_area_files{k};
    std_act_file  = strrep(std_area_files{k}, '.area.mat', '.act.mat');
    
    subj_area_file = [[brain_id, atlas_ids{k}], '.area.mat'];
    subj_act_file  = [[brain_id, atlas_ids{k}], '.act.mat'];
    
    if exist(std_area_file, 'file'), copyfile(std_area_file, subj_area_file); end
    if exist(std_act_file, 'file'),  copyfile(std_act_file, subj_act_file); end
end
