function	vb_area_to_reduce_brain(areafile, areakey, ...
                                 reducekey,reduced_areafile)
% Area index is transformed to area index in the reduced brain model
%   vb_area_to_reduce_brain(areafile, areakey)
%   vb_area_to_reduce_brain(areafile, areakey, reducekey,reduced_areafile)
% --- Input
%  areafile = 'xxx.area.mat'
%  areakey
% --- Optional input
%  reducekey : area key to specify reduced brain model
%            = 'reduced_cortex' (Default)
%  reduced_areafile ; area file for reduced brain model
%            = 'xxx_reduced.area.mat' (Default)
% --- Output
% Area index corresponding to areakey
% is converted to the area index in the reduced brain model
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('reducekey','var'), reducekey   = 'reduced_cortex'; end;

Area  = vb_get_area(areafile,reducekey);

if isempty(Area), 
	fprintf('No reduced brain key : [%s] in [%s]\n',reducekey,areafile)
	return
end

Ixall = Area.Iextract;
Nall  = length(Ixall);

Area  = vb_get_area(areafile,areakey);

if isempty(Area), 
	fprintf('No area key : [%s] in [%s]\n',areakey,areafile)
	return
end

Vindx = Area.Iextract;

Nmax = max(max(Vindx),Nall);
Itrans = zeros(Nmax,1);
Itrans(Ixall) = 1:Nall;

Rindx = Itrans(Vindx);
ixnz  = find( Rindx > 0 );
Rindx = Rindx(ixnz);

if ~exist('reduced_areafile','var') | isempty(reduced_areafile),
	reduced_areafile = vb_change_file_basename(areafile, '_reduce');
end

AreaNew.key = areakey;
AreaNew.Iextract = Rindx(:);
vb_add_area([reduced_areafile], AreaNew);
