function    [Vadd, Iadd, Vnew, Fnew] = vb_add_patch_vertex(overlap,V,F)
% add new vertex by dividing triangle patch locally
% [Vadd, Iadd, Vnew, Fnew] = vb_add_patch_vertex(overlap,V,F);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

add_mode = 1;
% = 1: add overlap vertex
% = 2: add overlap vertex and  its next neighbor

[xxD, xxF, xxT]= vb_next_distance(F,V);
% xxF{n} : ĺ n  ܶ˵ĺֹ
% xxD{n} : ĺ n  ܶ˵ Ȥ Υ
% xxT{n} : ĺ n  ܣֹ

% vertex index to add
Vindex = [];

for n = 1:overlap.Noverlap
    % overlaped old index
    ix_old = overlap.Ovlist(n);
    % add nearest neighbor point
    switch  add_mode
    case    1
        Vindex = [Vindex; ix_old];
    case    2
        Vindex = [Vindex; ix_old; xxF{ix_old}];
    end
end

% vertex index for divide
Vindex = unique(Vindex);

% make new vertex at midpoint of triangle edge
[Vnew, Fnew, Iparent] = vb_divide_patch(V, F, xxT, Vindex);

% vertex index for new vertex in Vnew
Iadd = Iparent(:,1);
Vadd = Vnew(Iadd,:);


return
