function Y = hann_win(X)
% ---
% function Y = hann_win(X)
% This function apply hanning window to given data. 
% size(X)=[N,T], where N is the number of signals and T is the 
% number of time samples. 
%
% 2004-10-04 Taku Yoshioka
% ---
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N,T] = size(X); 
h = 0.5-0.5*cos(2*pi*(0:T-1)./(T-1));
Y = X.*repmat(h,[size(X,1) 1]); 

