function [voxel, mri_trans_info] = neuromag_load_mri_info(fiffile)
% load neuromag mri-fiffile.
% [USAGE]
%    [voxel, mri_trans_info] = neuromag_load_mri_info(<fiffile>);
% [IN]
%    fiffile : neuromag MRI fiffile.
% [OUT]
%    voxel              : Voxel data in MRI fiffile. [X x Y x Z uint8]
%    mri_trans_info
%       .trans_head2mri : [4 x 4 double]
%                       : transformation matrix (HEAD ==> MRI(usually DICOM))
%       .trans_head2vox : [4 x 4 double]
%                       : transformation matrix (HEAD ==> Voxel)
%       .trans_vox2mri  : [4 x 4 double]
%                       : transformation matrix (VOXEL ==> MRI(usually DICOM))
%
% rH : position in Head coordinate
% rM : position in MRI coordinate
% rV : position in Voxel coordinate
% 
% [rM 1] = [rH 1] * trans_head2mri;
% [rM 1] = [rV 1] * trans_vox2mri;
% [rV 1] = [rH 1] * trans_head2vox;
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fiffile', 'var') || exist(fiffile, 'file') ~= 2
    error('invalid fiffile was specified.');
end

%
% --- Get MRI Data
%
hdr = fiff_read_mri(fiffile);
voxel_t = cat(3, hdr.slices.data);
voxel   = permute(voxel_t, [2 1 3]);

trans_vox2mri  = hdr.voxel_trans.trans;
trans_head2mri = hdr.trans.trans;


% [rM 1] = [rH 1] * trans_head2mri';
% [rM 1] = [rV 1] * trans_vox2mri';
% [rV 1] = [rM 1] / trans_vox2mri';
% [rV 1] = [rH 1] * trans_head2vox;
% trans_head2vox = trans_head2mri' / trans_vox2mri';

mri_trans_info = struct;
mri_trans_info.trans_head2mri = trans_head2mri';
mri_trans_info.trans_head2vox = trans_head2mri' / trans_vox2mri';
mri_trans_info.trans_vox2mri  = trans_vox2mri';
