function	trans_info = neuro_head_to_spm_transmat(trans_info,Vdim,Vsize)
% Transform matrix from Neuromag-Head coordinate to SPM coordinate
%  trans_mat = neuro_head_to_spm_transmat(trans_info,Vdim,Vsize)
% ---- Input
% trans_info.trans_head2vox : transform matrix (HEAD ==> Voxel)
%                           :  [4 x 4 double]
% Vdim  : Voxel dimension of Analize image
% Vsize : Voxel size of Analize image
% ---- Output
% trans_info.head2vox : transform matrix ( HEAD  ==> Voxel)
% trans_info.vox2spm  : transform matrix (Voxcel ==> SPM)
% trans_info.head2spm : transform matrix ( HEAD  ==> SPM)
%
% --- MRI-Voxel coordinate  (Image based)
%
% [Left-hand coordinate]
% X:Right(1) -> Left(256)   R->L
% Y:Front(1) -> Back(256)   A->P
% Z:Top(1)   -> Bottom(136) S->I
%
% --- SPM coordinate (Image based)
%
% [Right-hand coordinate]
% X: Left(-191/2)   -> Right(191/2) 
% Y: Back(-256/2)   -> Front(256/2)
% Z: Bottom(-256/2) -> Top(256/2) 
%
% --- Head coordinate
% X : from left to right : LPA -> RPA
% Y : from back to front : Nasion -> x-axis
% Z : from bottom to up.
%
% Vspm(:,1) =  ( - Vox(:,1) + Vdim(1)*0.5 )*Vsize(1);
% Vspm(:,2) =  ( - Vox(:,2) + Vdim(2)*0.5 )*Vsize(2);
% Vspm(:,3) =  ( - Vox(:,3) + Vdim(3)*0.5 )*Vsize(3);
% Vspm = Vspm*0.001; Change [mm] to [m]
%
% Masa-aki Sato 2009-4-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, error('Input argument error'); end

% Head -> Voxcel
head2vox = trans_info.trans_head2vox;

% Voxcel -> SPM
vox2spm = - diag(0.001*Vsize);
xtrans  = 0.5 * 0.001 * Vdim(:) .* Vsize(:);
vox2spm = [vox2spm ,xtrans ; zeros(1,3) 1]';

trans_info.vox2spm  = vox2spm;

% Head -> SPM
trans_info.head2spm = head2vox * vox2spm;
trans_info.head2vox = head2vox;
