function	check_neuromag_orient(mri_fiffile, analyzefile)
% Check orientation of image with analyzefile
%  check_neuromag_orient(mri_fiffile, analyzefile)
%     mri_fiffile : MRI fiffile.
%     analyzefile : analyze file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% change neuromag vox image to RAS
avw = change_neuromag_ras(mri_fiffile);

img = double( avw.img);

% dimension
dim   = avw.hdr.dime.dim(2:4);
vsize = avw.hdr.dime.pixdim(2:4);

% analyze image to RAS
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

% check dimension
errdim = sum(abs(Vdim(:) - dim(:)));
errsize = sum(abs(Vsize(:) - vsize(:)));

%voxͤʤΤǡB綯٤˹碌ͤˤ
vmax = max(img(:));
bmax = max(B(:));
B = fix(B *vmax/bmax);

% Check image data intensity
err = sum(abs( B(:) - img(:) ))/sum(abs(B(:)));

fprintf('Error of image = %g\n',err)
fprintf('Error of dim = %g\n',errdim)
fprintf('Error of voxcel size = %g\n',errsize)

