function   avw = change_neuromag_ras(mri_fiffile)
% change neuromag image orientation to RAS orientation
%   [avw] = change_neuromag_ras(mri_fiffile)
% --- Input
%     mri_fiffile : MRI fiffile.
% --- Output
% avw : Analyze data structure

% orient = get_orient_from_rot(R)
% R : rotation matrix from current axis to RAS coordinate
% --- orient
% orient : axis dim to get RAS coordinate
%        = [orient_x  orient_y  orient_z]
% orient_x : Left to Right axis dim of current image
% orient_y : Posterior to Anterior axis dim of current image
% orient_z : Inferior  to Superior  axis dim of current image
%
% Left to Right           1
% Posterior to Anterior   2
% Inferior to Superior    3
% Right to Left          -1
% Anterior to Posterior  -2
% Superior to Inferior   -3
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% load voxel data and transform matrix from mri fiffile.
[voxel, trans_info] = neuromag_load_mri_info(mri_fiffile);

% X_mri = R * X_vox
R = trans_info.trans_vox2mri(1:3,1:3)';

img = change_img_orient_ras(voxel,R);

dim = size(img);
% get scale factor
vsize = max(abs(R),[],2);

avw.img = img;
avw.hdr = [];

avw.hdr.dime.dim(2:4) = dim;
avw.hdr.dime.pixdim(2:4) = 1000 * vsize';
