function [result] = vb_mps_fileio_write(obj, output_file)
% mps_File(.mps.mat) output.
% [USAGE]
%    [result] = vb_mps_fileio_write(<obj>, <output_file>);
% [IN]
%    output_file : output filename
% [OUT]
%    result : SUCESS or FAILURE
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ~exist('obj', 'var'), error('obj is a required parameter'); end
if ~exist('output_file', 'var') || isempty(output_file)
    error('output_file is a required parameter');
end

global vbmeg_inst;

result = SUCCESS;

Analyzeinfo = obj.analyze_info;
Pointlist = cell(0);

%
% --- Formatting data
%
Vdim  = Analyzeinfo.Vdim;
Vsize = Analyzeinfo.Vsize;
const = vbmeg_inst.const;

NPoints = vb_mps_pointlist_get_pointnum(obj.point_list);

for k=1:NPoints
    [name, point] = vb_mps_pointlist_get_point(obj.point_list, k);

    point_mri = vb_analyze_right_to_spm_right(point.voxels, Vdim, Vsize);

    s = struct('coord_type', const.COORDINATE_SPM_RIGHT_M, ...
               'name', name, ...
               'point', point_mri);
    % Converted to SPM_Right m
    Pointlist{k} = s;
    % Base data
    Base{k}.name  = name;
    Base{k}.point = point;
end

% Save mps file (Overwrite mode)
vb_fsave(output_file, 'Analyzeinfo', 'Pointlist', 'Base');
