function [obj] = vb_display_factor_set_element_color(obj, mtype_cell)
% set element color to display.
% [USAGE]
%    [obj] = vb_display_factor_set_element_color(<obj>, <mtype_cell>);
% [IN]
%           obj : display_factor object
%    mtype_cell : marker type list {1xN}
%                 marker type is the same as defined by plot function.
%                 mtype_cell{k} represent color or display_factor.element{k} .
% [OUT]
%    obj : display_factor object
%
% Author: rhayashi
% Created: 2007-07-18
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('mtype_cell', 'var')
    error('mtype_cell is a required parameter.');
end

%
% --- Main Procedure
%
obj.mtype_cell = mtype_cell;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
