function [obj] = vb_display_factor_add_element(obj, display_element)
% Add display_element object to display_factor object.
% [USAGE]
%    [obj] = vb_display_factor_add_element(<obj>, <display_element>);
% [IN]
%                obj : display_factor object
%    display_element : display_element object
% [OUT]
%    obj : display_factor object
%
% Author: rhayashi
% Created: 2007-07-18
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('display_element', 'var')
    error('display_element is a required parameter.');
end

%
% --- Main Procedure
%
obj.element_cell{length(obj.element_cell)+1} = display_element;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
