function [obj] = vb_display_element_new(name, coord_type)
% display_element object constructor.
% But this class is virtual class(used by surf_element class ...)
% [USAGE]
%    [obj] = vb_display_element_new(<name>, <coord_type>);
% [IN]
%          name : <<char array>> name of this element 
%    coord_type : coordinate space of this element belongs to.
% [OUT]
%    obj : display_element object
%
% Author: rhayashi
% Created: 2007-07-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('name', 'var'), error('name is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end

%
% --- Main Procedure
%
obj = struct;
obj.class_name = 'display_element';
obj.name = name;
obj.coord_type = coord_type;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
