function uu = lcd_calc_residuals(J,conMAR,xx0)
% COMPUTE RESIDUALS OF MAR MODEL
%
% [Input]
% J    : timeseries data [Nv Nt]
% conMAR : concatenated MAR matrix [Nv Nv*dmax]
% xx0    : initial values 
%
% [Output]
% uu : residual timeseries [Nv Nt] 
%
% 2016/01/28 O.Yamashita

[Nvertex,Nt] = size(J);
[tmp, Nall] = size(conMAR);
dmax = Nall/Nvertex;

if nargin < 3
    xx0 = zeros(Nvertex,dmax);
end

% compute residuals
u = zeros(Nvertex,Nt+dmax);
x = [xx0 J];

for tt = dmax+1 : Nt+dmax
    if mod(tt,100)==0, fprintf('%02d ',tt); end
    x0 = x(:,tt-1:-1:tt-dmax);   
    x0 = x0(:);
    u(:,tt) = x(:,tt) - conMAR*x0;
         
end
fprintf('\n');

uu = u(:,dmax+1:end);
