function vb_freesurfer_run(mri_file, fs_root_dir, subj_id)
% Run FreeSurfer to get all files for VBMEG.
% [Usage]
%    vb_freesurfer_run(mri_file, fs_root_dir, subj_id)
% [Input]
%          mri_file : Input MRI T1 Image file name.
%                     This file should be created using convert_dicom_nifti.m
%                      - NIfTI file(.nii)
%                      - LAS Analyze file(.hdr/.img)
%       fs_root_dir : Root Dir for FS data.
%           subj_id : Subject ID , it becomes Sub-directory name.
%
% [Output files]
%  fs_root_dir/subj_id/bem/
%    - brain(cortex) model file
%     lh.smoothwm.asc : smooth cortical surface
%     rh.smoothwm.asc
%     lh.inflated.asc : inflated surface
%     rh.inflated.asc
%     lh.curv.asc     : curvature info file
%     rh.curv.asc
%     lh.white.asc    : cortical surface
%     rh.white.asc
%
%    - skull surface for BEM
%     inner_skull_surface.asc : inner skull surface
%     outer_skull_surface.asc : outer skull surface
%     outer_skin_surface.asc  : skin surface
%
%    - spherical registration surface
%     lh.sphere.reg.asc 
%     rh.sphere.reg.asc
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3
    eval(['help ' mfilename]);
    return;
end

%
% --- Previous check
%

if exist(fs_root_dir, 'dir') ~= 7
    error('fs_root_dir not found : %s', fs_root_dir);
end
if strfind(subj_id, ' ')
    error('subj_id contains white space : %s', subj_id);
end
if exist(mri_file, 'file') ~= 2
    error('mri_file not found : %s', mri_file);
end

if strcmp(mri_file(end-3:end), '.hdr')
    mri_file(end-3:end) = '.img';
end

%
% --- Main Procedure
%

% give a script permission for execution.
cmd = which('RunFreeSurfer.csh');
[result, err_txt] = system(['chmod 755 ' cmd]);
if result ~= 0
    error(err_txt);
end
dest_dir = fullfile(fs_root_dir, subj_id);
if exist(dest_dir, 'dir') == 7
    warning('FreeSurfer directory already exist. skip creating. :%s', dest_dir);
    return;
end
exe_cmd = [cmd, ' ', ...
           fs_root_dir, ' ',...
           subj_id, ' ', ...
           mri_file, ' ', ...
           '$FREESURFER_HOME'];

dmri_system(exe_cmd, '-echo');
