function dd = sq_distance(X,Y,flg)
% square distance matrix for X and Y
% case 1:
%  dd = sq_distance(X,Y)
%  dd = sq_distance(X,Y,flg)
%       flg = 0
%  X : (D x M) matrix 
%  Y : (D x N) matrix
% case 2:
%  dd = sq_distance(X,Y,flg)
%       flg = 1
%  X : (M x D) matrix 
%  Y : (N x D) matrix
%
%  dd = (X-Y)^2 = X^2 + Y^2 - 2*X*Y : (M x N) square distance matrix
%  D : space dimension of X and Y
%  M, N : number of points in X and Y
%  
%
%   2013-7-05 Masa-aki Sato 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin==2 || flg==0
	if (size(X,1) ~= size(Y,1))
	   error('dimension of X and Y are different ');
	end
	
	XX = sum(X.^2,1); % 1 x M
	YY = sum(Y.^2,1); % 1 x N
	XY = -2*X'*Y; % M x N
	
	%  (X-Y)^2 = X^2 + Y^2 - 2*X'*Y
	dd = vb_repadd( XY, XX');
	dd = vb_repadd( dd, YY);
else
	if (size(X,2) ~= size(Y,2))
	   error('dimension of X and Y are different ');
	end
	
	XX = sum(X.^2,2); % M x 1
	YY = sum(Y.^2,2); % N x 1
	XY = -2*X*Y'; % M x N
	
	%  (X-Y)^2 = X^2 + Y^2 - 2*X*Y'
	dd = vb_repadd( XY, XX);
	dd = vb_repadd( dd, YY');
end

dd = max(dd,0);
