function	[J, Y, tp] = set_cylinder_val(Y,U,t,dN)
% set values for cylinder
% [J, Y] = set_cylinder_val(Y,U,t,NP,dN)
%  Y : ring buffer for temporal histry
%  U : current state value
%  t : current time index
%  dN: number of cylinder points 
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NP = length(Y);

if isempty(U)
	y = Y;
	tc = mod(t-1 , NP) + 1;
	tp = mod(tc - (1:NP), NP) + 1;
	y = y(tp);
else
	% time index for ring buffer
	tc = mod(t-1 , NP) + 1;
	
	% set current state value
	Y(tc) = U;
	y = Y;
	
	% time index to show temporal histry
	tp = mod(tc - (1:NP), NP) + 1;
	y = y(tp);
end

% replicate values for cylinder
J = repmat(y(:), [1 dN]);
J = J'; J = J(:);
