function	[B3, Xdim, Ydim] = select_slice(B,indx,vdim)
% select slice from 3D image
%  [B3, Xdim, Ydim] = select_slice(B,indx,vdim)
%
% B : 3D-image [NBx, NBy, NBz]. The coordinate system must be RAS. 
%     Note that the default of ANALYZE coordinate is LAS. 
% indx : slice index in vdim-axis
% vdim : slice cut direction
%      = 'x' : Sagittal cut : Y-Z plane
%      = 'y' : Coronal cut : X-Z plane
%      = 'z' : Transverse (Axial) cut : X-Y plane
%  B3        selected 2D slice image
%  Xdim     
%  Ydim     
%
%  	image(Xdim, Ydim, B3, 'CDataMapping','scaled');
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


indx = round(indx);

[NBx,NBy,NBz]=size(B);

% dimension of image data
xdim = [0, NBx];
ydim = [0, NBy];
zdim = [0, NBz];

% Analyze-slice-cut direction
switch	vdim,
case	'x',
	 % 'SAG' : Sagittal cut : Y-Z plane
	 B2   = reshape(B(indx,:,:),NBy,NBz);
	 Xdim = ydim;
	 Ydim = zdim;
case	'y',
	 % 'COR' : Coronal cut : X-Z plane
	 B2   = reshape(B(:,indx,:),NBx,NBz);
	 Xdim = xdim;
	 Ydim = zdim;
case	'z',
	 % 'TRN' : Transverse (Axial) cut : X-Y plane
	 B2   = B(:,:,indx);
	 Xdim = xdim;
	 Ydim = ydim;
end;

% Squeeze to 2D
B2 = squeeze(B2); 

% RGB color matrix (gray level): transpose of 2D matrix for image plot
B3 = repmat(B2',[1 1 3]);

return
%%%%%%%%%%%%%--------------------END-----------------

[Nx,Ny] = size(B2);

% Index color -> True color
if nargin < 4
	B3 = repmat(B2,[1 1 3]);
	
	image(Xdim, Ydim, B3, 'CDataMapping','scaled');
else
	BC = zeros(Nx,Ny,3);
	BC(:,:,cdim) = B2;
%	
%	sum(BC(:) > 0)
	
	image(Xdim, Ydim, BC, 'CDataMapping','scaled');
end

set(gca,'YDir','normal','XLimMode','manual','YLimMode','manual');
axis equal
axis tight
