function	[V, id] = reduce_connection(d, p);
% --- reduce connection vertex
%   [V, id] = reduce_connection(d, p);
% --- path coordinate for n-th connection
%  d.Vc{n} : vertex coordinates along n-th connection path 
% --- pair of vetex index for n-th connection
%  d.I_from(n)   : start vertex index
%  d.I_to(n)     : end vertex index
% --- skip parameter
%  p.Nskip = skip number for connections selection
%  p.Nstep = skip number along path (neighbor distance= Nstep*0.2mm)
% --- output: reduced connection vertex
% V{n} : vertex 3D coordinate for n-th connections [Np x 3]
%  id.I_from(n)   : start vertex index for n-th connection
%  id.I_to(n)     : end vertex index for n-th connection
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% number of connections
NC = length(d.Vc);

% skip selection for connections
nlist = 1:p.Nskip:NC;

% --- pair of vetex index for n-th connection
id.I_from = d.I_from(nlist);
id.I_to   = d.I_to(nlist)  ;

N = length(nlist);
V = cell(N,1);

for n=1:N
	NP = size(d.Vc{nlist(n)},1);
	
	if p.Nstep < NP
		% skip points along path
		V{n} = d.Vc{nlist(n)}(1:p.Nstep:NP,:);
		
		if mod(NP,p.Nstep)~=0
			V{n} = [V{n}; d.Vc{nlist(n)}(end,:)];
		end
	else
		V{n} = d.Vc{nlist(n)}([1,NP],:);
	end
	if size(V{n},1) < 2,
		fprintf('# of point=%d\n',size(V{n},1))
	end
end
