function	[hfig, Q, id] = plot_cylinder_prepare(dc, p)
% --- path coordinate for n-th connection
%  dc.Vc{n} : vertex coordinates along n-th connection path 
% --- pair of vetex index for n-th connection
%  dc.I_from(n)   : start vertex index
%  dc.I_to(n)     : end vertex index
%  p : Plot parameter 
%
% 2014-11-10 Masa-aki Sato
% 2017-12-12 Yusuke Takeda Modified details
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(which('disp_brain.mat')); % 
d = Data_area;

% figure handle
hfig = [];

% reduce points for connection path
[X,id] = reduce_connection(dc, p);

% number of connections to show
NL = length(X);

%----- Make cylindrical vertex and patches for each connection pair
V = cell(NL,1);% vertex coordinate for cylindrical lines
F = cell(NL,1);% patch index for cylindrical lines
Q = cell(NL,1);% ring buffer for temporal histry

hfig.hp = zeros(NL,1);% figure handle

for n=1:NL
	% Make cylindrical vertex and patches for n-th connection
	[V{n},F{n},X{n}] = make_cylinder( X{n} ,p.dN,p.dr);
	
	% activity history ring buffer
	Q{n} = zeros(size(X{n},1),1);
end

if	p.mbox == 1
	hfig.h = msgbox('Cancel: Press OK button');
	set(hfig.h, 'DeleteFcn', 'global cancel; cancel = true;');
end

global cancel;
cancel = false;

hfig.hfig = figure('Color', 'k', 'Unit', p.fig_unit, 'Position', p.fig_pos);

eclr = 'none';

colormap(p.cmap);

%----- plot brain 
NFV = vb_reducepatch(d.F0, d.V0, 3000);

hfig.hf  = patch('Faces',NFV.faces,'Vertices',NFV.vertices, ...
	'FaceColor',p.faceclr,'EdgeColor',eclr);
set(gca, 'Color', 'k');
hold on
alpha(hfig.hf, p.alpha(1));

%----- lighting
lighting phong;
material dull;

camlight(-60,0);
camlight(60,0);
camlight(180,0);

Nkey = length(d.V);

%----- plot face
if p.face_on
    if exist(p.face_file, 'file') ~= 2
        warning('Specified facefile not found.');
    else
        load(p.face_file, 'surf_face');
        NFV = vb_reducepatch(surf_face.F, surf_face.V*1000, 40000);
        white = rgb_val_get('white');
        h_face = patch('Faces', NFV.faces, 'Vertices', NFV.vertices, ...
                       'FaceColor', white, 'EdgeColor', eclr);
        lighting phong;
        material dull;
        set(h_face, 'SpecularStrength', 0, 'AmbientStrength', 1.0);
        alpha(h_face, p.alpha_face);
        hfig.h_face = h_face;
    end
end

%----- plot brain area
hfig.h_area = zeros(1,Nkey);

if p.roi==1
	for n = 1:Nkey;
		fclr = d.cmap(n,:);
		if iscell(fclr), fclr = rgb_val_get(char(fclr)); end
		NFV = vb_reducepatch(d.F{n}, d.V{n}, 500); 
		
		hfig.h_area(n) = patch('Faces',NFV.faces,'Vertices',NFV.vertices, ...
			'FaceColor',fclr,'EdgeColor',eclr);
%        lighting phong;
%        material dull;
	end
	alpha(hfig.h_area, p.alpha_area(1));
end

%----- plot cylindrical lines
t = 1; r0 = 0.01;
for n=1:NL
	% set values for n-th cylinder
	[J, Q{n}] = set_cylinder_val(Q{n},[],t,p.dN);
	
	% set start-end vertex
	hfig.hp1(n) = plot3(X{n}(1,1),X{n}(1,2),X{n}(1,3),'.','MarkerSize',r0);
	hfig.hp2(n) = plot3(X{n}(end,1),X{n}(end,2),X{n}(end,3),'.','MarkerSize',r0);
	
	% plot cylindrical lines
	hfig.hp(n) = patch('Faces',F{n},'Vertices',V{n},'FaceColor','interp',...
	  'FaceVertexCData',J,'EdgeColor','none',...
	  'FaceLighting','none');
	
	%material shiny;%metal;dull
end

%alpha(hfig.hf, p.alpha)

axis equal
axis tight

% erase axis
set(gca,'XTick', [])
set(gca,'YTick', [])
set(gca,'ZTick', [])

set(gca,'XColor', 'k')
set(gca,'YColor', 'k')
set(gca,'ZColor', 'k')

angle = p.angle;
view(angle);

% time
current_axes = gca;
hfig.ax_time = axes;
set(hfig.ax_time, 'Position', [0.52, 0.1, 0.001, 0.001], ...
	'Units', 'normalized', 'Color', 'k');
set(hfig.hfig, 'CurrentAxes', current_axes);

% save figure
hfig.key  = d.key;
hfig.cmap = d.cmap;
guidata(hfig.hfig, hfig);
