function	plot_ch_label(parm,facefile,show_label,dx)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load([facefile],'Vspm','xx')

Rmax = 0.006;
%dx = 0.003;

% Find nearest point in face to get surface normal
[indx, dd] = vb_find_nearest_point(Vspm, parm.src_pos , Rmax, 100, 1);
sxx = dx * xx(indx,:);

[indx, dd] = vb_find_nearest_point(Vspm, parm.det_pos , Rmax, 100, 1);
dxx = dx * xx(indx,:);

% Plot channel label
for n=1:length(parm.source)
    ix = strmatch(parm.source{n}, show_label, 'exact');
	if ~isempty(ix)
		text(parm.src_pos(n,1)+sxx(n,1), parm.src_pos(n,2)+sxx(n,2),  ...
			parm.src_pos(n,3)+sxx(n,3), parm.source{n});
	end
end
	
for n=1:length(parm.detector)
    ix = strmatch(parm.detector{n}, show_label, 'exact');
	if ~isempty(ix)
		text(parm.det_pos(n,1)+dxx(n,1), parm.det_pos(n,2)+dxx(n,2),  ...
			parm.det_pos(n,3)+dxx(n,3), parm.detector{n});
	end
end
