function	[Z, I] = movie_current_load(id, p)
% load current for creating movie
%
% load parameters
% id.I_from : start vertex index
% id.I_to   : end vertex index
%
% 2014-11-10 Masa-aki Sato
% 2017-12-12 Yusuke Takeda
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


load(p.curr_file, 'Z', 'ix_roi')

% Convert from-index to index of Z
NP = length(ix_roi);
NM = max([ix_roi(:); id.I_from(:)]);
ID = zeros(NM,1);

% index convert table
ID(ix_roi) = 1:NP;

% convert from-index to index of Z
I_from = ID(id.I_from);

% exclude index outside of ix_roi
I = find(I_from > 0);

Z = Z(I_from(I),:);

if length(I) < length(I_from),
    fprintf('There are mismatch between ix_roi and Index_from!!\n\n')
end


