function	Data = make_area_surf(parm)
%--- brain surface
% Data.V0 
% Data.F0 
%--- area key to display
% Data.key 
% Data.cmap
%--- surfaces for area key to display
% Data.V  
% Data.F  
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if isfield( parm, 'keyfile') && ~isempty(parm.keyfile)
	[key , cmap]= textread(parm.keyfile, '%s %s','commentstyle','matlab');
else
	[key] = get_area_key(parm.conn_file,parm.areafile,parm.Nmin);
end

Nkey = length(key);

if ~exist('cmap','var') || isempty(cmap{1})
	cmap = make_color_map(Nkey);
end

keyid = get_area_id(key,parm.atlas_text);

% Read image-header
[dim, Trans] = vb_get_image_info(parm.atlas_file);
% dim(1:3) - the x, y and z dimensions of the volume
% Trans    - a 4x4 affine transformation matrix mapping from
%            voxel coordinates to MNI-mm-coordinates
% XYZmni = Trans * [XYZvox; 1]

% Read atlas-template image 
avw = avw_img_read(parm.atlas_file);
Z = avw.img;
% Z - 3D image data (label value)

if isfield(parm,'atlasbrain') && ~isempty(parm.atlasbrain)
	[V0,F0] = vb_load_cortex(parm.atlasbrain); % SPM-right-m
	
	%F0 = F0.F3;  % left + right cortex
	FL = F0.F3L; % left cortex
	FR = F0.F3R; % right cortex
	[Vdim, Trans0] = vb_get_image_info(parm.atlasimage);
	Vsize = diag(Trans0);
	Vana  = vb_spm_right_to_analyze_right(V0,Vdim,Vsize(1:3)');
	
	step = 1; % 1mm
	mask_mode = 0;
	
	B = vb_cortex_fill(Vana, F0, step, [],'LR', Vdim, mask_mode);
	B = vb_morphology_operation(B, parm.RadiusB);
	[F0, V0]  = vb_surf_extract(B);
	
	V0  = trans_mni_coord(V0, Trans0);
	
	% Transform vertex coordinate to analyze right-handed coordinate
%	[B, Vdim, Vsize] = vb_load_analyze_to_right(parm.atlasimage);
%	Vana   = vb_spm_right_to_analyze_right(V0,Vdim,Vsize);
%	V0  = trans_mni_coord(Vana, Trans0);
else
	% Morphology smoothing
	B = vb_image_to_mask(Z, 0.5);
	B = vb_morphology_operation(B, parm.RadiusB);
	
	[F0, V0]  = vb_surf_extract(B);
	
	V0 = trans_mni_coord(V0, Trans);
end

F = cell(Nkey,1);
V = cell(Nkey,1);
err_index = [];
for n = 1:Nkey;
    try
	Bval = [keyid(n) keyid(n)];
	B = vb_image_to_mask2(Z, Bval);
	B = vb_morphology_operation(B, parm.RadiusA);
	
	[F{n}, V{n}]  = vb_surf_extract(B);
	V{n} = trans_mni_coord(V{n}, Trans);
    catch
        err_index = [err_index; n];
    end
end

if ~isempty(err_index)
    key(err_index) = [];
    V(err_index) = [];
    F(err_index) = [];
    cmap(err_index, :) = [];
end

Data.V0 = V0;
Data.F0 = F0;
Data.FL = FL;
Data.FR = FR;
Data.V  = V;
Data.F  = F;
Data.key = key;
Data.cmap= cmap;
