function [Connection] = load_connection_from_vmni_connect_file(vmni_connect_file)
% load connection infomation
% [Usage]
%     [Connection] = load_connection_from_vmni_connect_file(vmni_connect_file);
%
% [Input]
%    vmni_connect file : Vmni connection file(Vmni_connect.mat)
%
% [Output]
%    Connection  : connection line information    <<struct>>
%           .Vc     : connection coordinate value    {Nx1}
%           .I_from : Vc{n,1}   : Index number of subject brain V. (start point)
%           .I_to   : Vc{n,end} : Index number of subject brain V. (end point) 

Connection = struct;
load(vmni_connect_file);

Connection.Vc = Vtracks_mni;
Connection.I_from = Index_from;
Connection.I_to   = Index_to;
