function	[Jpred, Ipred] = load_ar_dynamics(id, p, input)
% load AR dynamics parameter
%
% load parameters
% id.I_from : start vertex index
% id.I_to   : end vertex index
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if isempty(p.arfile)
    % id.I_from : start vertex index
    NP = length(id.I_from);
    w  = (rand(NP,1) + 2)*p.omega;
    t  = 0:p.dt:2*pi;
    Jpred = sin(w*t);
    Ipred = 1:NP;
elseif ~isempty(whos('-file', p.arfile, 'wsevents'))
    load(p.arfile);
    parcel_from_list = pairs(:, 1);
    Npair = length(parcel_from_list);
    
    Ntime = size(wsevents, 2);
    Jpred = zeros(Npair, Ntime);
    for k=1:Npair
        Jpred(k, :) = wsevents(parcel_from_list(k), :);
    end
    Ipred = 1:Npair;
elseif ~isempty(whos('-file', p.arfile, 'MAR'))
    load(p.arfile,'MAR','Delta','omega','Index_orig')
    
    if nargin==3
        omega = input;
    end
    
    % Predicted currents (Output of the system with the input 'omega')
    [Jpred] = forward_prediction(MAR, Delta, omega);
    
    %plot(Jpred(Index_orig==I_from(nv),:))
    
    % Index_orig correspond to Jpred
    
    % Convert from-index to index of Jpred
    NP = length(Index_orig);
    NM = max([Index_orig(:); id.I_from(:)]);
    ID = zeros(NM,1);
    
    % index convert table
    ID(Index_orig) = 1:NP;
    
    % convert from-index to index of Jpred
    I_from = ID(id.I_from);
    
    % exclude index outside of Index_orig
    Ipred = find(I_from > 0);
    
    Jpred = Jpred(I_from(Ipred),:);
    
    if length(Ipred) < length(I_from),
        fprintf('There are mismatch between Index_orig and Index_from!!\n\n')
    end
else
    load(p.arfile, 'Z', 'Index_orig')
    Jpred = Z;
    
    % Convert from-index to index of Jpred
    NP = length(Index_orig);
    NM = max([Index_orig(:); id.I_from(:)]);
    ID = zeros(NM,1);
    
    % index convert table
    ID(Index_orig) = 1:NP;
    
    % convert from-index to index of Jpred
    I_from = ID(id.I_from);
    
    % exclude index outside of Index_orig
    Ipred = find(I_from > 0);
    
    Jpred = Jpred(I_from(Ipred),:);
    
    if length(Ipred) < length(I_from),
        fprintf('There are mismatch between Index_orig and Index_from!!\n\n')
    end
end

