function	cmap = cmap_move(parm)
%----- colormap for moving signal
%   C = cmap_move(parm)
% parm.Nlevel  =  gradation color level
% parm.Nwidth  =  active color region length
% parm.Ncycle  =  cycle length
% parm.Nrepeat =  repeat number of active cycle
% 
% parm.active_color =  color map name for active state
% parm.rest_color   =  color name for rest state
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

active_color = rgb_val_get(parm.active_color);
rest_color   = rgb_val_get(parm.rest_color  );
back_color   = rgb_val_get(parm.back_color  );


%---- nonlibear map for active color
Ncycle  = parm.Ncycle;
Nrepeat = parm.Nrepeat;
Nlevel  = Ncycle * (Nrepeat + parm.Nback);
Nlevel0 = Ncycle * parm.Nback;
Nback   = Ncycle - parm.Nwidth;

switch	parm.mode
case	 'gradation'
%---- Make base gradation color
	cmap = cmap_gradation([active_color; rest_color], Nlevel);
case	 'jet'
	cmap = jet(Nlevel);
case	 'hot'
	cmap = hot(Nlevel);
end

% back color at the bottom
ix_back0 = 1:Nlevel0;

% repeat back color
ix_back = 1:Nback;
ix_back = repmat(ix_back(:), [1 Nrepeat]) ...
		+ repmat((0:(Nrepeat-1))*Ncycle, [Nback 1]);
ix_back = ix_back(:) + Nlevel0;
ix_back = [ix_back0(:); ix_back];

cmap(ix_back,:)  = repmat( back_color ,[length(ix_back), 1]);
%----------------END-----------------
plot_mode=0;

if plot_mode==0, return; end;

%----------------Plot-----------------
colorbar_plot(cmap)
