function	C = cmap_move(para)
%----- colormap for moving signal
%   C = cmap_move(para)
% para.Nlevel  =  gradation color level
% para.Nwidth  =  active color region length
% para.Ncycle  =  cycle length
% para.Nrepeat =  repeat number of active cycle
% para.Nback   =  repeat number of background cycle
% para.mode    =  nonlibear map for active color {'exp' , 'gauss'}
% 
% para.active_color =  color name for active state
% para.rest_color   =  color name for rest state
% para.back_color   =  color name for background
%
% 2014-11-10 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

active_color = rgb_val_get(para.active_color);
rest_color   = rgb_val_get(para.rest_color  );
back_color   = rgb_val_get(para.back_color  );

%---- Make base gradation color
C0 = cmap_gradation([active_color; rest_color], para.Nlevel);

%---- nonlibear map for active color
cmax = para.Nlevel;
cmin = ceil( max(cmax/10, 1));

ix = nonlinear_map(cmax,cmin, para.Nwidth, para.mode);
Cact = C0(ix,:);

%---- cycle of active-rest color
Cact_cycle = cmap_cycle(Cact, back_color, para.Ncycle, para.Nrepeat);

%---- add background color region
Cback = cmap_cycle(back_color,back_color, para.Ncycle * para.Nback,1);

C  = [Cback; Cact_cycle];

%----------------END-----------------
plot_mode=0;

if plot_mode==0, return; end;

%----------------Plot-----------------
subplot(2,2,1)
colorbar_plot(C0)
title('Base gradation map')
xlim([1 size(C0,1)])

subplot(2,2,2)
colorbar_plot(Cact)
title('Gaussian transformed active color map')
xlim([1 size(Cact,1)])

subplot(2,2,3)
colorbar_plot(Cact_cycle)
title('Active color cycle')
xlim([1 size(Cact_cycle,1)])

subplot(2,2,4)
colorbar_plot(C)
title('Combined color map')
xlim([1 size(C,1)])
