function disp_conn_data_make(vmni_connect_file, vbmeg_brain_file, data_conn_file) 
% Create connection data file for display.
%
% [Input]
%    vmni_connect_file : [input file]  vmni_connect file.
%     vbmeg_brain_file : [input file]  VBMEG BRAIN-MAT file   : Subject.brain.mat
%       data_conn_file : [output file] connection data file for display.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin ~= 3
    error('Please check function usage.');
end

%
% --- Previous check
%
if exist(vmni_connect_file, 'file') ~= 2
    error('vmni_connect_file not found.');
end
if exist(vbmeg_brain_file, 'file') ~= 2
    error('vbmeg_brain_file not found.');
end

%
% --- Main Procedure
%
outfile   = data_conn_file;

% Connection pair index file
conn_file = vmni_connect_file;

% output directory creation
out_dir = fileparts(outfile);
if exist(out_dir, 'dir') ~= 7
    mkdir(out_dir);
end

%------- Input File 
atlas_dir       = [fileparts(which('ch2.img')), filesep];
parm.atlas_file = [atlas_dir 'aal.img'];
parm.conn_file  = conn_file;
parm.brainfile  = vbmeg_brain_file;

%--- Output file
parm.outfile = outfile;

if isfield(parm,'outfile') && ~isempty(parm.outfile) ...
%	&& ~exist(parm.outfile,'file')

	Data.Vc = load_connection_dti(parm);
	
	load(parm.conn_file, 'Index_to', 'Index_from');
	
	Data.I_to  = Index_to;
	Data.I_from= Index_from;
	
	fprintf('disp_conn_data_make done\n\n')
	% --- path coordinate for n-th connection
	%  Data.Vc{n}       : vertex coordinates along n-th connection path 
	% --- pair of vetex index for n-th connection
	%  Data.I_from(n)   : start vertex index
	%  Data.I_to(n)     : end vertex index
	
	save([parm.outfile],'Data')
end
