function ok = write_clut_tmp(lindex, lrgb, lvals, clutfile, subjid)
% ok = write_clut(lindex, lrgb, lvals, clutfile, <subjid>)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% write_label.m
%
% Original Author: Doug Greve
% CVS Revision Info:
%    $Author: nicks $
%    $Date: 2011/03/02 00:04:13 $
%    $Revision: 1.4 $
%
% Copyright ?? 2011 The General Hospital Corporation (Boston, MA) "MGH"
%
% Terms and conditions for use, reproduction, distribution and contribution
% are found in the 'FreeSurfer Software License Agreement' contained
% in the file 'LICENSE' found in the FreeSurfer distribution, and here:
%
% https://surfer.nmr.mgh.harvard.edu/fswiki/FreeSurferSoftwareLicense
%
% Reporting: freesurfer@nmr.mgh.harvard.edu
%
% Original is write_label.m
% 2012/06/24 M.Fukushima
% 2014/06/09 M.Fukushima

ok = 0;

if(nargin ~= 4 & nargin ~= 5)
  fprintf('ok = write_label(lindex, lxzy, lvals, clutfile, <subjid>)\n');
  return;
end

if(exist('subjid') ~= 1) subjid = ''; end % 2012/04/27 M.Fukushima 'subid'->'subjid'

if(isempty(lindex) & isempty(lrgb))
  fprintf('ERROR: both lindex and lrgb are empty.\n');
  return;
end

if(~isempty(lindex) & ~isempty(lrgb))
  npoints1 = length(lindex); 
  npoints2 = size(lrgb,1); 
  if(npoints1 ~= npoints2)
    fprintf('ERROR: lindex and lrgb have different lengths.\n');
    return;
  end
  npoints = npoints1;
elseif(~isempty(lindex))
  npoints = length(lindex); 
  lrgb = zeros(npoints,3); 
elseif(~isempty(lrgb))
  npoints = length(lrgb); 
  lindex = zeros(npoints,1); 
end

if(size(lrgb,2) ~= 3)
  fprintf('ERROR: lrgb does not have 3 columns\n');
  return;
end

if(~isempty(lvals)) 
  if(npoints ~= length(lvals))
    fprintf('ERROR: length of lvals inconsistent\n');
    return;
  end
else
  lvals  = zeros(npoints,1); 
end

% open as an ascii file
fid = fopen(clutfile, 'w') ;
if(fid == -1)
  fprintf('ERROR: could not open %s\n',clutfile);
  return;
end

fprintf(fid,'#\n\n');
fprintf(fid,'#No. Label Name:  R   G   B   A\n\n');

% Make sure they are npoints by 1 %
lindex = reshape(lindex,[npoints 1]);
lrgb   = reshape(lrgb,[npoints 3]);
lvals  = reshape(lvals,[npoints 1]);

fprintf(fid,'%d   subcortex     %d   %d   %d   %d\n',0,0,0,0,0);
for n = 1:npoints
  fprintf(fid,'%d   parcel%d     %d   %d   %d   %d\n',...
    n,lindex(n),lrgb(n,1),lrgb(n,2),lrgb(n,3),lvals(n));
end

fclose(fid) ;

ok = 1;

return;
