function save_connection(dir_name, trackfile, ofile, cfile)
% Compute connection count and mean fiber length
% Input
%  dir_name: Directory name where voxel images made by 'fsl2ascii' locate
%  trackfile: .tck file made by streamtrack in MRtrix 
%   [relative path to dir_name]
%  ofile: Output file containing mm coodinate of all the voxels in the mask
%   [absolute path]
%  Nlabel: Number of label files
%  cfile: MAT file containing connection parameters to be saved
%   [absolute path]
%
% 2012/06/15 M.Fukushima
% 2012/06/26 M.Fukushima
% 2014/05/29 rhayashi     Input arugment Nlabel is deleted.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% % Add path to MRtrix directory
% addpath('/usr/share/mrtrix/matlab');

tic
% Compute connection count and mean fiber length
[connect, count, fiber_length, mfiber_length, Noverlap, track_parm] = ...
  calc_connection(dir_name, trackfile, ofile);
toc

% Save parameters
save(cfile,'connect','count','fiber_length','mfiber_length','Noverlap','track_parm');
