function save_anat_matrix(dir_name, Nlabel, cfile_base, cmatfile)
% Save annatomical connectivity matrix w.r.t. connection strength and 
% mean fiber length
% Input
%  dir_name: Directory name where connection parameters are saved
%  Nlabel: Number of label files
%  cfile_base: basename of MAT files containing connection parameters
%  cmatfile: MAT file containning connectivity matrices to be saved
%   [absolute path]
% 
% 2012/06/19 M.Fukushima
% 2012/06/29 M.Fukushima
% 2012/06/30 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

c_count = zeros(Nlabel);
f_leng = zeros(Nlabel);
Ntrack = zeros(Nlabel,1);
t_count = zeros(Nlabel,1);
count = [];

for ii = 1:Nlabel
  cfile = fullfile(dir_name, filesep, [cfile_base num2str(ii) '.mat']);
  load(cfile)
  count = count(1:Nlabel);
  mfiber_length = mfiber_length(1:Nlabel);
  
  c_count(:,ii) = count;
  f_leng(:,ii) = mfiber_length;
  Ntrack(ii) = length(Noverlap); % 2012/09/29 M.Fukushima
  if isfield(track_parm,'total_count')==0
    t_count(ii) = 0;
  else
    t_count(ii) = str2num(track_parm.total_count);
  end
  
  if mod(ii,10)==0
    fprintf('%d/%d done.\n',ii,Nlabel);
  elseif ii == Nlabel
    fprintf('%d/%d done.\n',ii,Nlabel);
  end
end

save(cmatfile, 'c_count', 'f_leng', 'Ntrack', 't_count')
