function dmri_freesurfer_surf_view(freesurfer_dir)
% Launch application to confirm cortical surface model 
% which is created by freesurfer.
%
% [Usage]
%    dmri_freesurfer_surf_view(freesurfer_dir);
%
% [Input]
%    freesurfer_dir : freesurfer subject directory.
%
% [Output]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 1
    error('Please check input argument.');
end
if exist(freesurfer_dir, 'dir') ~= 7
    error('Specified freesurfer_dir is invalid.');
end

%
% --- Main Procedure
%

% Create temporary script file
temp_shell_file = [tempname, '.sh'];

dmri_script_file_create(temp_shell_file);
fid = fopen(temp_shell_file, 'a');
if fid == -1
    error('Failed to open script file.');
end

[SUBJECTS_DIR, SUBJ] = fileparts(freesurfer_dir);

% Write command
fprintf(fid, '%s\n', ['SUBJECTS_DIR=' SUBJECTS_DIR]);

cmd = ['tkmedit', ...
       ' ', SUBJ, ...
       ' brainmask.mgz -aux wm.mgz -surfs'];
fprintf(fid, '%s\n', cmd);
fclose(fid);

% Execute
dmri_system(temp_shell_file);
delete(temp_shell_file);
