function dmri_add_images(fileA, fileB, output_file)
% Add images (fileA + fileB), then create output_file.
%
% [Usage]
%    dmri_add_images(fileA, fileB, output_file);
%
% [Input]
%          fileA : fileA       - gzipped Nifti file(.nii.gz)
%          fileB : fileB       - gzipped Nifti file(.nii.gz)
%    output_file : output file - gzipped Nifti file(.nii.gz)
%
% [Output]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 3
    error('Please check function usage.');
end

%
% --- Main Procedure
%
cmd = ['fslmaths', ...
       ' '     , fileA, ...
       ' -add ', fileB, ...
       ' '     , output_file];
dmri_system(cmd);
