function [mTracks] = calc_mean_streamlines(Tracks)
% Averaging coordinates of streamlines for each ROI pairs
%
% 2015/03/24 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Ncon = length(Tracks);
iTracks = Tracks;
mTracks = cell(Ncon,1);

% Interporate streamlines for averaging
for ii = 1:Ncon
  fprintf(['Interporate coordinates of streamlines for vertex pair #' num2str(ii) ':\n'])
  
  if ~isempty(Tracks{ii})
    Nsline = zeros(length(Tracks{ii}),1);
    for jj = 1:length(Tracks{ii})
      % Numbers of steps in streamlines
      Nsline(jj) = size(Tracks{ii}{jj},1);
    end
    mNsline = min(Nsline); % or max(Nsline);
    
    % Interporate streamlines
    for jj = 1:length(Tracks{ii})
      Ntrack = size(Tracks{ii}{jj},1);
      y = zeros(Ntrack,3);
      x = zeros(Ntrack,3);
      yy = zeros(mNsline,3);
      xx = zeros(mNsline,3);
      for kk = 1:3
        x(:,kk) = 1:Ntrack;
        % Streamlines to be interporated
        y(:,kk) = Tracks{ii}{jj}(:,kk);
        
        xx(:,kk) = 1:(Ntrack-1)/(mNsline-1):Ntrack;
        % Interporated streamlines
        yy(:,kk) = spline(x(:,kk), y(:,kk), xx(:,kk));
      end
      iTracks{ii}{jj} = yy;
    end
  end
end

% Compute streamlines averaged within each ROI pairs
for ii = 1:Ncon
  fprintf(['Averaging coordinates of streamlines for vertex pair #' num2str(ii) ':\n'])
  
  if ~isempty(iTracks{ii})
    % Averaging streamlines
    mTracks{ii} = zeros(size(iTracks{ii}{1}));
    for jj = 1:length(iTracks{ii})
      mTracks{ii} = mTracks{ii} + iTracks{ii}{jj};
    end
    mTracks{ii} = mTracks{ii}/length(iTracks{ii});
  end
end
