%
%

clear
close all

DIRECTORIES = {'/home/cbi/endo/dmri_processor/endo245/DTI/processed/',...
    '/home/cbi/endo/dmri_processor/okada243/b1000/DTI/processed/',...
    '/home/cbi/endo/dmri_processor/okada243/b2500/processed/'};

SAVEFILES = {'endo2500_cmat_distmat.mat',...
    'okada1000_cmat_distmat.mat',...
    'okada2500_cmat_distmat.mat'};

for dd = 1 : length(DIRECTORIES),

    dirname = DIRECTORIES{dd};
    savefile = SAVEFILES{dd};

  
    brainfile = [dirname 'vbmeg/Subject.brain.mat'];
    areafile  = [dirname 'vbmeg/Subject_aal.area.mat'];
    dmrifile  = [dirname 'connectivity/connectivity.dmri.mat'];

    [CC,DD,xyz0,Keys0]=dmri_connections_regions_calc(dmrifile, brainfile, areafile);
    
    S=struct('cmat', CC, 'distmat', DD, 'xyz0', xyz0, 'brainfile',brainfile,'areafile',areafile,'dmrifile',dmrifile);
    S.Keys0 = Keys0;


    save(savefile,'-struct','S');
    
end
