function dmri_process_cortex_import(p)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

disp(mfilename);

%
% --- Previous check 
%
if isfield(p, 'ref_brain_file') && exist(p.ref_brain_file, 'file') == 2
    if isfield(p, 'ref_aal_area_file') && exist(p.ref_aal_area_file, 'file') == 2
        warning('VBMEG Cortical files creating step is skipped because p.ref_brain file specified.');
        return;
    end
end
if isfield(p, 'ref_brain_file') && ~isempty(p.ref_brain_file)
    error('Specified VBMEG cortical file not found. :%s', p.ref_brain_file);
end
if isfield(p, 'ref_aal_area_file') && ~isempty(p.ref_aal_area_file)
    error('Specified VBMEG AAL-area file not found. :%s', p.ref_aal_area_file);
end

% Start Importing freesurfer files
start = tic;
if isfield(p, 'ref_fs_dir') && ~isempty(p.ref_fs_dir)
    freesurfer_dir = p.ref_fs_dir;
else
    freesurfer_dir = fullfile(p.output_dir, p.fs_dirname, p.fs_sbj_name);
end
if isfield(p, 'ref_mri_file') && ~isempty(p.ref_mri_file)
    mri_file = p.ref_mri_file;
else
    mri_file = fullfile(p.output_dir, p.t1_dirname, ['m', p.t1_file]);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% not necessary to edit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
brain_parm = vb_set_brain_parm(); % get default parameter
brain_parm.FS_left_file         = [freesurfer_dir, '/', 'bem/lh.smoothwm.asc'];
brain_parm.FS_right_file        = [freesurfer_dir, '/', 'bem/rh.smoothwm.asc'];
brain_parm.FS_left_infl_file    = [freesurfer_dir, '/', 'bem/lh.inflated.asc'];
brain_parm.FS_right_infl_file   = [freesurfer_dir, '/', 'bem/rh.inflated.asc'];
brain_parm.FS_left_curv_file    = [freesurfer_dir, '/', 'bem/lh.curv.asc'];
brain_parm.FS_right_curv_file   = [freesurfer_dir, '/', 'bem/rh.curv.asc'];
brain_parm.FS_left_sphere_file  = [freesurfer_dir, '/', 'bem/lh.sphere.reg.asc'];
brain_parm.FS_right_sphere_file = [freesurfer_dir, '/', 'bem/rh.sphere.reg.asc'];
brain_parm.FS_sphere_key        = 'sphere.reg';
brain_parm.FS_left_label_file   = [freesurfer_dir, '/', 'label/lh.cortex.label'];
brain_parm.FS_right_label_file  = [freesurfer_dir, '/', 'label/rh.cortex.label'];

% registration method to standard brain model.
%     = 'FS' : Freesurfer sphere file is used.
brain_parm.registration_mode='FS';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output directory/file settings
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
proj_root = fullfile(p.output_dir, p.vbmeg_dirname);
if exist(proj_root, 'dir') ~= 7
    mkdir(proj_root);
end
brain_parm.analyze_file = mri_file;
brain_parm.brain_file = [p.vbmeg_cortex_basename, '.brain.mat'];
brain_parm.area_file =  [p.vbmeg_cortex_basename, '.area.mat'];
brain_parm.act_file =   [p.vbmeg_cortex_basename, '.act.mat'];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cortical model import
vb_job_brain(proj_root, brain_parm);

toc(start);
